function Figure1D
% Running this script produces the plots shown in Figure 1D

mAb_names = {'Negative','CR9501','5C4','ADI-19425','Motav','101F','ADI-14359','ADI-14353'};

% C3-positive percentages:
mAb(1,:) = [0.033431 0.012152 0.0059609]*100;
mAb(2,:) = [0.27266 0.35921 0.13513]*100;
mAb(3,:) = [0.20373 0.22117 0.07524]*100;
mAb(4,:) = [0.013802 0.01135 0.0051961]*100;
mAb(5,:) = [0.17968 0.26007 0.080759]*100;
mAb(6,:) = [0.017198 0.019372 0.0077492]*100;
mAb(7,:) = [0.037043 0.037159 0.010041]*100;
mAb(8,:) = [0.0607 0.10468 0.016135]*100;

dq = 0.2*(rand(size(mAb))-.5);
q = [ [0:7]' [0:7]' [0:7]'] + dq;
for k = 0:7
  semilogy([k-.5 k+.5],mean(mAb(k+1,:))*[1 1],'k'); hold on;
end
semilogy(q(:,1),mAb(:,1),'s','MarkerSize',8,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]);
semilogy(q(:,2),mAb(:,2),'s','MarkerSize',8,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); 
semilogy(q(:,3),mAb(:,3),'s','MarkerSize',8,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); hold off;
xticks([0:7]);
xticklabels(mAb_names); xtickangle(45);
title('Pre-F Data')
ylim([0.3 100])
ylabel('Percent C3-positive particles')
clear

%==========================================================================
% mAb:F data
m101F = [0.13936 0.15603 0.12992];
m5C4 = [0.21052 0.19797 0.17071];
m14353 = [0.0069977 0.018283 0.0071919];
m14359 = [0.0059733 0.015319 0.0065459];
m19425 = [0.12509 0.13319 0.10923];
mCR9501 = [0.17428 0.16259 0.15165];
mMot = [0.20248 0.21821 0.18953];
neg = [0.0014896 0.0012657 0.0024617];

mAb_names = {'Negative','CR9501','5C4','ADI-19425','Motav','101F','ADI-14359','ADI-14353'};

figure;
q = 0; dq = [-.1 0 .1];
semilogy(q+dq,neg,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); hold on; q = q + 1;
semilogy(q+dq,mCR9501,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,m5C4,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,m19425,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,mMot,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,m101F,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,m14359,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]); q = q + 1;
semilogy(q+dq,m14353,'.','MarkerSize',24,'Color',[0.5 0.5 0.5],'MarkerFaceColor',[0.5 0.5 0.5]);
ylim([0.001 1]);
xticks([0:7]);
xticklabels(mAb_names); xtickangle(45);
title('Pre-F Data')
ylabel('mAb/F [AU]')